USE OLAP

--Tabular data from an ealier chapter. 
SELECT order_method_type
       ,format(sum(profit),'C') as total_profit --call this column total_profit
FROM sales_enriched
GROUP BY order_method_type

--As a view
GO
CREATE VIEW profit_by_order_method_type AS
SELECT order_method_type
       ,format(sum(profit),'C') as total_profit --call this column total_profit
FROM sales_enriched
GROUP BY order_method_type
GO

--Query the view
SELECT * FROM profit_by_order_method_type

--Filter with where clause
SELECT * FROM profit_by_order_method_type
WHERE order_method_type = 'E-mail'